<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    ShowFormAddEditor()
  ===================================================*/

  function ShowFormAddEditor() {

    // vars global configuration
    global $category_separator, $admin_template_path;

    // vars url & form

    // vars messages
    global $msg;

    // vars template
    global $category;
    
    // generate category
    
    $category_obj = new clsCategory;
    $category_obj->table_name = "idx_category";
    $category_obj->separator = $category_separator;
    $category = $category_obj->DisplayCategoryListBox(-1);

    DisplayTemplate($admin_template_path . "editor_add_form.html", "\$category");
  }


  /*===================================================
    ProcessFormAddEditor()
  ===================================================*/

  function ProcessFormAddEditor() {

    // vars global configuration
    global $category_separator, $admin_template_path;

    // vars url & form
    global $cat, $username;

    // vars messages
    global $msg;

    // vars template
    global $message, $back;

    // verify input

    if(empty($cat)) $error_msg = $msg["20201"];
    elseif(empty($username)) $error_msg = $msg["20202"];
    elseif($username=='admin') $error_msg = $msg["20205"];

    if(empty($error_msg)) {

      $users_obj = new clsUsers;
      $users_obj->table_name = "idx_users";
      $check_result = $users_obj->CheckUsername($username);

      // if username is exist
      if($check_result==0) {

        $links_obj = new clsLink;
        $links_obj->table_name = "idx_link";
        $links_obj->category_table_name = "idx_category";
        $links_obj->editor_table_name = "idx_editor";
        $links_obj->user_table_name = "idx_users";

        $editor_list = $links_obj->GetEditor($cat);

        if (!is_array($editor_list)) {
          $editor_list = array();
        }
        
        if (in_array($username,$editor_list)) {
          // already become editor for this category
          $message = $msg["20204"];
        }
        else {
          $add_result = $links_obj->BecomeEditor("process_form",$username,$cat,true);
          $message = $msg["20211"];
          $back = "<a href=editor_add.php>Back</a>";
        }
      }
      else $message = $msg["20203"];
    }
    else $message = $error_msg;
    
    DisplayTemplate($admin_template_path . "message.html", "\$message,\$back");
  }


  /*===================================================
    main
  ===================================================*/

  include "../application.php";
  
  RunPreFilter(__FILE__);

  DisplayTemplate($admin_template_path . "header.html");
  if (empty($pflag)) {
    ShowFormAddEditor();
  }
  elseif ($pflag == 'add') {
    ProcessFormAddEditor();
  }
  DisplayTemplate($admin_template_path . "footer.html");

  RunPostFilter(__FILE__);

?>